//
//  MCOVStackResultsPane.h
//  MCApplication
//
//  Created by Ali Lalani on 05/02/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "MCStackResultsPane.h"

extern NSString *MCOVStackResultsPaneSelectNext;
extern NSString *MCOVStackResultsPaneSelectPrevious;

extern NSString *ResultsControllerArrangedObjectsContext;
extern NSString *ParentItemIDChangedContext;

extern NSString *DataSourceResultsContext;

@class MCPOutlineViewDataSource;
@interface MCOVStackResultsPane : MCStackResultsPane {
	MCPOutlineViewDataSource *ovDataSource;

	NSMutableArray *selectedItems;

	int numberOfRows;
	NSIndexSet *selectedIndexes;
}
#pragma mark Actions
- (IBAction)openSelection:(id)sender;

#pragma mark ResultsManagement
- (void)resetResults;
- (void)removeSubItemsFromArray:(NSMutableArray *)array;
- (void)selectItems:(NSArray *)selItems inOutlineView:(id)outlineView;

#pragma mark Accessors
- (MCPOutlineViewDataSource *)ovDataSource;
- (void)setOvDataSource:(MCPOutlineViewDataSource *)anOvDataSource;

- (NSMutableArray *)selectedItems;
- (void)setSelectedItems:(NSMutableArray *)aSelectedItems;

- (int)numberOfRows;
- (void)setNumberOfRows:(int)aNumberOfRows;

- (NSIndexSet *)selectedIndexes;
- (void)setSelectedIndexes:(NSIndexSet *)anIndexSet;
@end
